// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000
// Procedures for viewing the individual keys in a key ring.
//..........................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpKeyRingIcon;
extern	LPCTSTR				lpszNullString;
extern	BOOL				bProcessInProgress;
extern	LPBYTE				lpRingFile1;
extern	BYTE				TypeKey;
extern	DWORD				dwPublicKeys;
extern	DWORD				dwPublicIds;
extern	DWORD				dwPublicSigs;
extern	DWORD				dwSecretKeys;
extern	DWORD				dwSecretIds;
extern	LPTSTR				lpszNA;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	U_IDX_FMT			UserIdIndex1;
extern	DWORD				dwIdxOffset1;
extern	DWORD				dwIdxOffset2;
extern	DWORD				dwIdxSize1;
extern	HHOOK				hHook;
extern	DWORD				dwN_Bits;
extern	TCHAR				TimeSep;
extern	MD5_CTX				Md5Context;
extern	HWND				hMainWindow;
extern	BYTE				KeySID;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpIndexFile2;
extern	HANDLE				hIdxHandle2;
extern	LPBYTE				lpEncAddress;
extern	BYTE				TempUserId;
extern	TCHAR				szPassPhrase1[250];
extern	int					iLengthOfPassPhrase;
extern	UINT				uiGetPassPhraseMsg;
extern	BOOL				bLogo;
extern	int					RtMargin;
extern	int					iMaxWidth;
extern	SHACONTEXT			ShaContext;
extern	BOOL				bRestrictionsInEffect;
extern	BOOL				bAa;
extern	LPBYTE				lpKeyBufferDup1;
extern	LPBYTE				lpKeyBufferDup2;
extern	UINT				uiWheelScrollLines;
extern	CONFIG				cfg;

// A couple of local macros.
//..........................
#define Col(x) ((x + RtMargin) * xChar)
#define Line(y) (y * yChar)

// Define the BHEX instruction that changes a hex value
// in al into two hex digits in ah and al.
//.....................................................
#define	BHEX __asm _emit 0xd4 __asm _emit 0x10

#define MAX_LINES	400

// Variables for the view key ring procedures.
//............................................
LPCTSTR			lpszViewKeyRings = "ViewKeyRings";
HWND			hViewWindow;
BOOL			bViewWindowDisplayed = FALSE;
HWND			hViewStatusBar;
HWND			hViewComboBox;
int				iOldSelection;
int				iNewSelection;
HWND			hCurrentFocusWin;
DWORD			dwChangeFocus;
BOOL			bScrollWnd;
BOOL			bSizeWnd;
DWORD			dwOldHelpNumber;
HANDLE			hKeyEvent;
HANDLE			hKeyOpen;

// Variables for the scrolling the view window.
//.............................................
int				xClient;		// Width of client area.
int				yClient;		// Height of client area.
int				xClientMax;		// Maximum width of client area.

int				xChar;			// Horizontal scrolling unit.
int				yChar;			// Vertical scrolling unit.

int				xPos;			// Current horizontal scrolling position.
int				yPos;			// Current vertical scrolling position.

int				xMax;			// Maximum horizontal scrolling position.
int				yMax;			// Maximum vertical scrolling position.

int				xInc;			// Horizontal scrolling increment.
int				yInc;			// Vertical scrolling increment.

int				iTotalLines;	// Total lines to be displayed.

RECT			BitMapRect;
SCROLLINFO		sci;
PAINTSTRUCT		ps;
HDC				hDC;
HDC				hCompatDC;
HBITMAP			hbm;
TEXTMETRIC		tm;

// Mousewheel delta.
//..................
int				iDelta;

// Character variables for displaying the key.
//............................................
TCHAR			Key1[]	= "Key ID:";
TCHAR			Key2[]	= "CTB:";
TCHAR			Key3[]	= "Version:";
TCHAR			Key4[]	= "Time Stamp:";
TCHAR			Key5[]	= "Validity Period:";
TCHAR			Key6[]	= "Algorithm Byte:";
TCHAR			Key7[]	= "Exponent e:";
TCHAR			Key8[]	= "Exponent d:";
TCHAR			Key9[]	= "Prime p:";
TCHAR			Key10[]	= "Prime q:";
TCHAR			Key11[]	= "Inverse u:";
TCHAR			Key12[] = "Forever";
TCHAR			Key13[] = "RSA";
TCHAR			Key14[] = "UNK";
TCHAR			Key15[] = "This KEY was created on                  at          GMT";
TCHAR			Key16[] = "This KEY is valid until          GMT on                 ";
TCHAR			Key17[] = "Md5 Fingerprint =";
TCHAR			Key18[] = "Modulus n:";
TCHAR			Key19[] = "OWNERTRUST:";
TCHAR			Key20[] = "User ID:";
TCHAR			Key21[] = "BUCKSTOP";
TCHAR			Key22[] = "DISABLED-V";
TCHAR			Key23[] = "Uninitialized Trust";
TCHAR			Key24[] = "Secret Key Components:";
TCHAR			Key25[] = "Unknown Key Owner";
TCHAR			Key26[] = "No Trust to Sign";
TCHAR			Key27[] = "CheckSum:";
TCHAR			Key28[] = "Usually Trust to Sign";
TCHAR			Key29[] = "Always Trust to Sign";
TCHAR			Key30[] = "On Secret Key Ring";
TCHAR			Key31[] = "No Trust in Key's Ownership";
TCHAR			Key32[] = "Marginal Trust in Key's Ownership";
TCHAR			Key33[] = "Complete Trust in Key's Ownership";
TCHAR			Key34[] = "Do Not Trust This Signature";
TCHAR			Key35[] = "Reasonable Trust in Signature";
TCHAR			Key36[] = "Complete Trust in Signature";
TCHAR			Key37[] = "Ultimately Trusted Signature";
TCHAR			Key38[] = "WARNONLY";
TCHAR			Key39[] = "CHECKED";
TCHAR			Key40[] = "CONTIG";
TCHAR			Key41[] = "Unknown Enciphering Algorithm, can't display Components.";
TCHAR			Key42[] = "Secret Key Components Not Decrypted";
TCHAR			Key43[] = "WARNING: Secret Key Components not Encrypted";
TCHAR			Key44[] = "Signature Certificate:";
TCHAR			Key45[] = "Key Certification -";
TCHAR			Key46[] = "Generic";
TCHAR			Key47[] = "No ID";
TCHAR			Key48[] = "Casual ID";
TCHAR			Key49[] = "Positive ID";
TCHAR			Key50[] = "KEY COMPROMISE";
TCHAR			Key51[] = "Key ID:";
TCHAR			Key52[] = "SIG ID:";
TCHAR			Key53[] = "Public Key of Signer Not on Our Public Key Ring.";
TCHAR			Key54[] = "Owner's SIG";
TCHAR			Key55[] = "SIGNED BY SELF";
TCHAR			Key56[] = "SIGTRUST:";
TCHAR			Key57[] = "KEYLEGIT:";
TCHAR			Key58[] = "Unknown Trust in Key's Ownership";
TCHAR			Key59[] = "Unknown Signature Owner";
TCHAR			Key60[] = "Not Counted in KEYLEGIT Trust";
TCHAR			Key61[] = "This SIG was created on                  at          GMT";
TCHAR			Key62[] = "DISABLED-C";
TCHAR			Key63[] = "UNKNOWN";
TCHAR			Key64[] = "Sha1 Fingerprint =";
TCHAR			Key65[] = "Not Authorized to view Secret Key Components.";
TCHAR			Key66[] = "Md5";
TCHAR			Key67[] = "Sha1";
TCHAR			Key68[] = "Sha512";

TCHAR			Line1[90];
SYSTEMTIME		stCreated;
SYSTEMTIME		stValidity;
SYSTEMTIME		stSigTime;
TCHAR			szTime[] = "%02d%s%02d%s%02d";
TCHAR			szBits[24];
TCHAR			szLeftP[] = "(";
TCHAR			szRightP[] = ")";
TCHAR			szDays[] = " Day(s)";

// View the public key ring.
//..........................
VOID ViewPublicKeyRing()
{
	RECT		rect;

	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);
	TypeKey = PUBLIC_KEY;

	// Create our event for the viewing the contents of a key ring.
	//.............................................................
	hKeyEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("KeyEvent"));
	if (!hKeyEvent)
	{
		ErrorProcedure(TEXT("KeyEvent"),IDS_CREATEEVENT,MB_OK);
		goto PubKeyEnd;
	}
	GetClientRect(hMainWindow,&rect);

	// Create the window for viewing the public keys.
	//...............................................
	hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszViewKeyRings,
								 lpszNullString,WS_CAPTION |
								 WS_CHILD | WS_SYSMENU | WS_HSCROLL | 
								 WS_VSCROLL | WS_VISIBLE |
								 WS_CLIPCHILDREN,rect.left,rect.top+37,
								 rect.right,rect.bottom-59,hMainWindow,NULL,
								 hInst,NULL);
	if (!hViewWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto PubKeyEnd;
	}
	// Open the event object.
	//.......................
	hKeyOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("KeyEvent"));
	if (!hKeyOpen)
	{
		DestroyWindow(hViewWindow);
		goto PubKeyEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hKeyEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	PubKeyEnd:

	if (hKeyOpen)
	{
		CloseHandle(hKeyOpen);
		hKeyOpen = 0;
	}
	if (hKeyEvent)
	{
		CloseHandle(hKeyEvent);
		hKeyEvent = 0;
	}
}

// View the secret key ring.
//..........................
VOID ViewSecretKeyRing()
{
	RECT		rect;

	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_ONE);
	TypeKey = SECRET_KEY;

	// Create our event for the viewing the contents of a key ring.
	//.............................................................
	hKeyEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("KeyEvent"));
	if (!hKeyEvent)
	{
		ErrorProcedure(TEXT("KeyEvent"),IDS_CREATEEVENT,MB_OK);
		goto SecKeyEnd;
	}
	GetClientRect(hMainWindow,&rect);

	// Create the window for viewing the secret keys.
	//...............................................
	hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszViewKeyRings,
								 lpszNullString,WS_CAPTION | WS_CHILD |
								 WS_SYSMENU | WS_HSCROLL | WS_VSCROLL | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,
								 rect.top+37,rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);
	if (!hViewWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto SecKeyEnd;
	}
	// Open the event object.
	//.......................
	hKeyOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("KeyEvent"));
	if (!hKeyOpen)
	{
		DestroyWindow(hViewWindow);
		goto SecKeyEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hKeyEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	SecKeyEnd:

	if (hKeyOpen)
	{
		CloseHandle(hKeyOpen);
		hKeyOpen = 0;
	}
	if (hKeyEvent)
	{
		CloseHandle(hKeyEvent);
		hKeyEvent = 0;
	}
}

// Register the window class to use for viewing key rings.
//........................................................
BOOL RegisterViewWindow()
{
	WNDCLASS	wc;

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	 = (WNDPROC)ViewWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpKeyRingIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszViewKeyRings;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for processing message for view key ring window.
//..................................................................
LRESULT CALLBACK ViewWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL			bResult;

	switch(uMsg)
	{
		case WM_CREATE:
		{
			TCHAR			szTempFileName[MAX_PATH];
			TCHAR			szStatusBarText[MAX_PATH];
			HMENU			hViewWinMenu;
			MENUITEMINFO	mii;
			DWORD			dwComboBoxRecords;
			int				iResult;
			
			ShowScrollBar(hWnd,SB_BOTH,TRUE);

			// Disable the move menu item on the window menu.
			//...............................................
			hViewWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hViewWinMenu,SC_MOVE,FALSE,&mii);

			// Set the title for the window. Use the name of 
			// the key ring.
			//..............................................
			CopyMemory(szTempFileName,lpRingFile1,MAX_PATH);
			PathStripPath(szTempFileName);
			SetWindowText(hWnd,szTempFileName);

			// Setup and create the status bar.
			//.................................
			if (TypeKey == PUBLIC_KEY)
			{
				StringCbPrintf((LPTSTR)&szStatusBarText,sizeof(szStatusBarText),
							    TEXT("Keys: %d     User IDs: %d      Signatures: %d"),
								dwPublicKeys,dwPublicIds,dwPublicSigs);
			}
			else
			{
				StringCbPrintf((LPTSTR)&szStatusBarText,sizeof(szStatusBarText),
								TEXT("Keys: %d            User IDs: %d"),
								dwSecretKeys,dwSecretIds);
			}
			hViewStatusBar = CreateStatusWindow(WS_CHILD | WS_BORDER | WS_VISIBLE,
											    szStatusBarText,hWnd,ID_VIEWSTATUSBAR);
			if (!hViewStatusBar)				
			{				
				ErrorProcedure(lpszNA,IDS_CREATESTATUSBAR,MB_OK);
				return(-1);
			}
			// Create the drop down list combo box.
			//.....................................
			hViewComboBox = CreateWindow("COMBOBOX",NULL,WS_TABSTOP | WS_CHILD | WS_VISIBLE |
										 WS_VSCROLL | WS_CLIPSIBLINGS | CBS_DROPDOWNLIST,
										 0,0,400,250,hWnd,NULL,hInst,NULL);
			if (!hViewComboBox)
			{
				ErrorProcedure(lpszNA,IDS_CREATEWINDOW,MB_OK);
				return(-1);
			}

			bResult = RewindAllKeyRingFiles();
			if (!bResult)
			{
				return(-1);
			}
			// Setup the default DC for our window.
			//.....................................
			hDC = GetDC(hWnd);
			if (!hDC)
			{
				return(-1);
			}
			// Create a compatable DC and bitmap to hold at least 
			// 400 lines of text.
			//...................................................
			hCompatDC = CreateCompatibleDC(hDC);
			if (!hCompatDC)
			{
				goto ErrorCreate;
			}
			// Setup our fixed pitch font to use.
			//...................................
			SelectObject(hCompatDC,GetStockObject(ANSI_FIXED_FONT));
			GetTextMetrics(hCompatDC,&tm);
			yChar = tm.tmHeight + tm.tmExternalLeading;
			xChar = tm.tmMaxCharWidth;

			RtMargin = 0;

			if (!cfg.dwLeftAlign)
			{
				// Get centering information for the window.
				//..........................................
				iMaxWidth = GetSystemMetrics(SM_CXMAXIMIZED);

				RtMargin = (((iMaxWidth / xChar) - 81) / 2) - 2;

				if (RtMargin < 0)
				{
					RtMargin = 0;
				}
			}
			// Arbitary max width of client area.
			//...................................
			xClientMax = ((81 + RtMargin) * xChar);

			// Set the mapping mode.
			//......................
			SetMapMode(hCompatDC,MM_TEXT);

			// Setup a rect for the bitmap.
			//.............................
			BitMapRect.left = 0;
			BitMapRect.top = 0;
			BitMapRect.right = xClientMax;
			BitMapRect.bottom = 404 * yChar;

			hbm = CreateCompatibleBitmap(hDC,BitMapRect.right,BitMapRect.bottom);
			if (!hbm)
			{
				goto ErrorCreate;
			}
			// Select the bitmap into the compatible DC.
			//..........................................
			SelectObject(hCompatDC,hbm);

			// Allocate memory for the buffers we will use.
			//.............................................
			lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
			lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
			
			if (!lpKeyBuffer1 || !lpKeyBuffer2)
			{
			  ErrorCreate:
				if (lpKeyBuffer1)
				{
					ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
					DeallocateMemory(lpKeyBuffer1);
					lpKeyBuffer1 = 0;
				}
				if (lpKeyBuffer2)
				{
					ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
					DeallocateMemory(lpKeyBuffer2);
					lpKeyBuffer2 = 0;
				}
				if (hCompatDC)
				{
					DeleteDC(hCompatDC);
					hCompatDC = 0;
				}
				if (hbm)
				{
					DeleteObject(hbm);
					hbm = 0;
				}			
				return(-1);
			}
			// Populate the drop down list combobox.
			//......................................
			if (TypeKey == PUBLIC_KEY)
			{
				dwComboBoxRecords = dwPublicIds;
			}
			else
			{
				dwComboBoxRecords = dwSecretIds;
			}
			while(dwComboBoxRecords > 0)
			{
				bResult = ReadIndex1();
				if (!bResult)
				{
					goto ErrorCreate;
				}
				iResult = SendMessage(hViewComboBox,CB_ADDSTRING,0,
									 (LPARAM)&UserIdIndex1.USER_ID);

				if (iResult == CB_ERR || iResult == CB_ERRSPACE)
				{
					ErrorProcedure(lpszNA,IDS_ADDSTRING,MB_OK);
					goto ErrorCreate;
				}
				// Get the next record if there is one.
				//.....................................
				dwIdxOffset1 += dwIdxSize1;

				dwComboBoxRecords--;
			}
			// Set the current selection to index 0.
			//......................................
			SendMessage(hViewComboBox,CB_SETCURSEL,0,0);
			iOldSelection = 1;
			iNewSelection = 0;

			// Setup the first key to view.
			//.............................
			bResult = SetupKeyToView(hWnd);
			if (!bResult)
			{
				goto ErrorCreate;
			}
			bViewWindowDisplayed = TRUE;

			// We have a process in progress.
			//...............................
			bProcessInProgress = TRUE;

			// Setup the hook procedure to trap the tab key so we
			// can switch between child and parent windows.
			//...................................................
			hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapViewTabKey,NULL,0);
			dwChangeFocus = 1;

			// Setup the help topic for viewing the key rings.
			//................................................
			dwOldHelpNumber = ChangeHelpTopic(IDH_VIEWKEYRINGS);
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			bResult = SetupKeyToView(hWnd);
			if (!bResult)
			{
				DestroyWindow(hWnd);
			}
			else
			{
				bSizeWnd = TRUE;
				InvalidateRect(hWnd,NULL,FALSE);
			}
		}
		break;

		case WM_COMMAND:
		{
			if (HIWORD(wParam) == CBN_CLOSEUP)
			{
				// Make sure it is our combobox.
				//..............................
				if (hViewComboBox == (HWND)lParam)
				{
					iNewSelection = SendMessage(hViewComboBox,CB_GETCURSEL,0,0);
					if (iNewSelection != iOldSelection)
					{
						bResult = SetupKeyToView(hWnd);
						if (!bResult)
						{
							DestroyWindow(hWnd);
						}
						else
						{
							bSizeWnd = TRUE;
							InvalidateRect(hWnd,NULL,FALSE);
						}
					}
					else
					{
						// Put the focus back on the view window.
						//.......................................
						SetFocus(hWnd);
						hCurrentFocusWin = hWnd;
					}
				}
			}
		}
		break;

		case WM_PAINT:
		{
			PRECT	prect;
			BOOL	bHaveUpdate;

			bHaveUpdate = GetUpdateRect(hWnd,NULL,FALSE);

			BeginPaint(hWnd,&ps);

			// Draw the lines of text from the bitmap.
			//........................................
			if (bSizeWnd)
			{
				BitBlt(hDC,ps.rcPaint.left,ps.rcPaint.top,xClient,yClient,
					   hCompatDC,xPos * xInc,yPos * yInc,SRCCOPY);
			}
			if (bScrollWnd)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			if (!bScrollWnd && !bSizeWnd && bHaveUpdate)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}

			bSizeWnd = FALSE;
			bScrollWnd = FALSE;
			EndPaint(hWnd,&ps);
			SetFocus(hWnd);
		}
		break;
									
		case WM_SIZE:
		{
			// Retrieve the dminension of the client area.
			//............................................
			yClient = HIWORD(lParam);
			xClient = LOWORD(lParam);

			xPos = 0;
			yPos = 0;

			// Determine the maximum vertical scrolling position.
			// The two is added for extra space below the lines
			// of text and the status bar.
			//...................................................
			yMax = max(0,iTotalLines + 2 - (yClient/yChar));

			// Make sure the current vertical scrolling position
			// does not exceed the maximum.
			//..................................................
			yPos = min(yPos,yMax);

			sci.cbSize = sizeof(SCROLLINFO);
			sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
			sci.nMin = 0;
			sci.nMax = iTotalLines - 1;
			sci.nPage = (yClient/yChar) + 1;
			sci.nPos = yPos;

			EnableScrollBar(hWnd,SB_VERT,ESB_ENABLE_BOTH);
			SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);

			// Determine the maximum horizontal scrolling position.
			//.....................................................
			xMax = max(0,((xClientMax - xClient)/xChar));

			// Make sure the current horizontal scrolling position
			// does not exceed the maximum.
			//....................................................
			xPos = min(xPos,xMax);
			
			sci.cbSize = sizeof(SCROLLINFO);
			sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
			sci.nMin = 0;
			sci.nMax = 81 + RtMargin - 1;
			sci.nPage = (xClient / xChar) + 1;
			sci.nPos = xPos;

			EnableScrollBar(hWnd,SB_HORZ,ESB_ENABLE_BOTH);
			SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);

			// Resize the status bar.
			//.......................
			MoveWindow(hViewStatusBar,0,HIWORD(lParam)-10,LOWORD(lParam),HIWORD(lParam),FALSE);

			// Redisplay the key.
			//...................
			bSizeWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			if (hHook)
			{
				UnhookWindowsHookEx(hHook);
				hHook = 0;
			}
			// Zero and deallocate the memory for the buffers.
			//................................................
			if (lpKeyBuffer1)
			{
				ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
				DeallocateMemory(lpKeyBuffer1);
				lpKeyBuffer1 = 0;
			}
			if (lpKeyBuffer2)
			{
				ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
				DeallocateMemory(lpKeyBuffer2);
				lpKeyBuffer2 = 0;
			}
			if (hCompatDC)
			{
				DeleteDC(hCompatDC);
				hCompatDC = 0;
			}
			if (hbm)
			{
				DeleteObject(hbm);
				hbm = 0;
			}
			// Change back to the old help number.
			//....................................
			ChangeHelpTopic(dwOldHelpNumber);

			bProcessInProgress = FALSE;
			bViewWindowDisplayed = FALSE;

			// Notify the view key ring file procedure it can continue.
			//.........................................................
			SetEvent(hKeyEvent);
		}
		break;

		case WM_HSCROLL:
		{
			switch (LOWORD(wParam))
			{
				// We clicked the shaft left of the scroll box.
				//.............................................
				case SB_PAGELEFT:
				{
					xInc = -8;
					break;
				}
				// We clicked the shaft right of the scroll box.
				//..............................................
				case SB_PAGERIGHT:
				{
					xInc = 8;
					break;
				}
				// We clicked the left arrow.
				//...........................
				case SB_LINELEFT:
				{
					xInc = -1;
					break;
				}
				// We clicked the right arrow.
				//............................
				case SB_LINERIGHT:
				{
					xInc = 1;
					break;
				}
				// We dragged the scroll bar.
				//...........................
				case SB_THUMBTRACK:
				{
					xInc = HIWORD(wParam) - xPos;
					break;
				}
				default:
					xInc = 0;
			}
			// If applying the horizontal scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//........................................................
			if (xInc = max(-xPos, min(xInc, xMax-xPos)))
			{
				bScrollWnd = TRUE;
				xPos += xInc;
				ScrollWindowEx(hWnd,-xChar * xInc,0,NULL,NULL,
							   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = xPos;
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}

		case WM_MOUSEWHEEL:
		{
			int			iIncrements;

			if (uiWheelScrollLines != 0)
			{
				// Default value.
				//...............
				yInc = 0;

				if (wParam & (MK_SHIFT | MK_CONTROL))
				{	
					return(DefWindowProc(hWnd,uMsg,wParam,lParam));
				}
				iDelta -= (SHORT) HIWORD(wParam);
				iIncrements = iDelta / WHEEL_DELTA;
				iDelta %= WHEEL_DELTA;

				if (iIncrements != 0)
				{
					if (uiWheelScrollLines == WHEEL_PAGESCROLL)
					{
						if (iIncrements < 0)
						{
							// PageUp.
							//.......
							yInc = min(-1,-yClient / yChar);
						}
						else
						{
							yInc = max(1,yClient / yChar);
						}
					}
					else
					{
						yInc = iIncrements * uiWheelScrollLines;
					}
				}
				// If applying the vertical scrolling increment does not
				// take the scrolling position out of the scrolling range,
				// increment the scrolling position, adjust the position
				// of the scroll box, and update the window.
				//.......................................................
				if (yInc = max(-yPos, min(yInc, yMax - yPos)))
				{
					bScrollWnd = TRUE;
	
					yPos += yInc;
				
					// Only scroll the window if yInc is less than yClient.
					// If greater or equal to yClient invalidate the whole
					// rectangle and redraw it.
					//....................................................
					if (abs(yInc) < yClient)
					{
						ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
									   NULL,NULL,SW_INVALIDATE | SW_ERASE);
					}
					else
					{
						InvalidateRect(hWnd,NULL,TRUE);
					}

					sci.cbSize = sizeof(SCROLLINFO);
					sci.fMask = SIF_POS;
					sci.nPos = yPos;
					SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
					UpdateWindow(hWnd);
				}
			}
		}
		break;
	
		case WM_VSCROLL:
		{
			switch(LOWORD(wParam))
			{
				// We clicked the shaft above the scroll box.
				//...........................................
				case SB_PAGEUP:
				{
					yInc = min(-1,-yClient / yChar);
					break;
				}
				// We clicked the shaft below the scroll box.
				//...........................................
				case SB_PAGEDOWN:
				{
					yInc = max(1,yClient / yChar);
					break;
				}
				// We clicked the top arrow.
				//..........................
				case SB_LINEUP:
				{
					yInc = -1;
					break;
				}
				// We clicked the bottom arrow.
				//.............................
				case SB_LINEDOWN:
				{
					yInc = 1;
					break;
				}
				// We dragged the scroll box.
				//...........................
				case SB_THUMBTRACK:
				{
					yInc = HIWORD(wParam) - yPos;
					break;
				}
				// We used the home key to go to the top.
				//.......................................
				case SB_TOP:
				{
					yInc = -yMax;
					break;
				}
				// We used the end key to go to the bottom.
				//.........................................
				case SB_BOTTOM:
				{
					yInc = yMax;
					break;
				}

				default:
					yInc = 0;
			}
			// If applying the vertical scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//.......................................................
			if (yInc = max(-yPos, min(yInc, yMax - yPos)))
			{
				bScrollWnd = TRUE;

				yPos += yInc;
				
				// Only scroll the window if yInc is less than yClient.
				// If greater or equal to yClient invalidate the whole
				// rectangle and redraw it.
				//....................................................
				if (abs(yInc) < yClient)
				{
					ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
								   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				}
				else
				{
					InvalidateRect(hWnd,NULL,TRUE);
				}

				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = yPos;
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}
		// Capture the keyboard keys for manipulating the scroll bars.
		//............................................................
		case WM_KEYDOWN:
		{
			WORD	wScrollAction = 0xFFFF;
			UINT	ScrollMsg = WM_VSCROLL;

			switch(wParam)
			{
				case VK_UP:
				{
					wScrollAction = SB_LINEUP;
					break;
				}
				case VK_DOWN:
				{
					wScrollAction = SB_LINEDOWN;
					break;
				}
				case VK_PRIOR:
				{
					wScrollAction = SB_PAGEUP;
					break;
				}
				case VK_NEXT:
				{
					wScrollAction = SB_PAGEDOWN;
					break;
				}
				case VK_HOME:
				{
					wScrollAction = SB_TOP;
					break;
				}
				case VK_END:
				{
					wScrollAction = SB_BOTTOM;
					break;
				}
				// Take care of the horizontal scroll bar.
				//........................................
				case VK_LEFT:
				{
					wScrollAction = SB_LINELEFT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_RIGHT:
				{
					wScrollAction = SB_LINERIGHT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_ESCAPE:
				{
					DestroyWindow(hWnd);
					break;
				}
			}
			if (wScrollAction != -1)
			{
				SendMessage(hWnd,ScrollMsg,MAKELONG(wScrollAction,0),0L);
			}
			break;
		}		
        default:
			return(DefWindowProc(hWnd,uMsg,wParam,lParam));
	}
    return(0L);
}

// Setup the key we have selected to view.
//........................................
BOOL SetupKeyToView(HWND hWnd)
{
	LARGE_INTEGER	li;
	BOOL			bResult = FALSE;
	DWORD			dwBytesRead;
	DWORD			dwCtb_Byte;
	DWORD			dwSizeLengthField;
	DWORD			dwKeyLength;
	LARGE_INTEGER	liTimestampTemp;
	LARGE_INTEGER	liSigTimeStamp;
	DWORD			dwValidTemp;
	LARGE_INTEGER	liValidityTimestamp;
	LPBYTE			lpReturnAddress;
	DWORD			dwFingerPrintValue;
	DWORD			dwScratchBits;
	DWORD			dwPreviousPacket;
	DWORD			dwUserIDLength;
	LPBYTE			lpUserID;
	DWORD			dwBytesToPrint;
	DWORD			dwCheckSum;
	DWORD			dwBytesToEncipher;
	LPBYTE			lpSigEndAddress;
	int				iDlgResult;
	BYTE			TempByte;
	BYTE			TrustByte;
	BYTE			TempTime[6];

	// Change the focus back to the view window.
	//..........................................
	SetFocus(hWnd);
	hCurrentFocusWin = hWnd;

	// Fill the rectangle with a white background.
	//............................................
	FillRect(hCompatDC,&BitMapRect,(HBRUSH)(COLOR_WINDOW+1));
	SelectObject(hCompatDC,GetStockObject(NULL_BRUSH));
	SetBkColor(hCompatDC,GetSysColor(COLOR_WINDOW));

	// Set total lines to 2.
	//......................
	iTotalLines = 2;

	// We have a new selection. Calculate the index address and read
	// the index file, and then the key file.
	//..............................................................
	dwIdxOffset1 = (iNewSelection * dwIdxSize1);
	dwBytesRead = ReadIndex1();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto SetupEnd;
	}
	dwBytesRead = ReadRecord1();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto SetupEnd;
	}
	// Print the strings to our compatable hDC and bitmap.
	//....................................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		mov		al,byte ptr [edi]
		mov		cl,al
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE

		// Save the size of the length field.
		//...................................
		mov		dwSizeLengthField,edx

		// Get and save the total length of the key. Does not
		// include the user id.
		//...................................................
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwKeyLength,eax
	}
	// Print the first line which includes the key id, CTB and version.
	//.................................................................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),Key1,lstrlen(Key1));
	TextOut(hCompatDC,Col(35),Line(iTotalLines),Key2,lstrlen(Key2));
	TextOut(hCompatDC,Col(68),Line(iTotalLines),Key3,lstrlen(Key3));

	// Set the text color to blue for the items in the line.
	//......................................................
	SetTextColor(hCompatDC,RGB(0,0,255));

	// Get the key id, the last 32 bits of Modulus n.
	//...............................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,dwSizeLengthField
		add		edi,KEY_HDR1_SIZE
		movzx	eax,word ptr [edi]
		xchg	ah,al			// Make little endian
		mov		dwN_Bits,eax

		// Point to the first byte of modulus n, then to the last
		// 4 bytes of modulus n which is the key id.
		//.......................................................
		add		eax,7
		shr		eax,3
		add		edi,MPI_PREFIX_SIZE
		sub		eax,SHORT_KEY_ID
		add		edi,eax
		mov		lpKeyBufferDup1,edi
	}
	// Change the key id to hex.
	//..........................
	ChangeToHex(SHORT_KEY_ID,lpKeyBufferDup1,Line1,FORWARD);
	TextOut(hCompatDC,Col(9),Line(iTotalLines),Line1,lstrlen(Line1));

	// Convert the CTB byte to hex.
	//.............................
	ChangeToHex(1,lpKeyBuffer1,Line1,FORWARD);
	TextOut(hCompatDC,Col(40),Line(iTotalLines),Line1,lstrlen(Line1));

	// Convert the version byte to hex.
	//.................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,CTB_SIZE
		add		edi,dwSizeLengthField
		mov		lpKeyBufferDup1,edi
	}
	ChangeToHex(1,lpKeyBufferDup1,Line1,FORWARD);
	TextOut(hCompatDC,Col(77),Line(iTotalLines),Line1,lstrlen(Line1));
	iTotalLines++;

	// Set the text color back to green for the header.
	//.................................................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),Key4,lstrlen(Key4));
	TextOut(hCompatDC,Col(28),Line(iTotalLines),Key5,lstrlen(Key5));
	TextOut(hCompatDC,Col(60),Line(iTotalLines),Key6,lstrlen(Key6));

	// Put the text color back to blue.
	//.................................
	SetTextColor(hCompatDC,RGB(0,0,255));

	// Convert the timestamp to hex.
	//..............................
	liTimestampTemp.QuadPart = 0;
	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,VERSION_SIZE
		mov		lpKeyBufferDup1,edi
		mov		eax,dword ptr [edi]
		mov		dword ptr TempTime[1],eax
		bswap	eax
		mov		liTimestampTemp.LowPart,eax

		// Get the other byte of the time stamp.
		//......................................
		mov		eax,dword ptr [edi+6]
		and		eax,0xff
		shr		eax,1
		mov		TempTime,al
		mov		liTimestampTemp.HighPart,eax
	}
	ChangeToHex(5,(LPBYTE)&TempTime,Line1,FORWARD);
	TextOut(hCompatDC,Col(13),Line(iTotalLines),Line1,lstrlen(Line1));

	// Convert the validity field to decimal or FOREVER if 0.
	//.......................................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,TIMESTAMP_SIZE
		mov		lpKeyBufferDup1,edi
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwValidTemp,eax
	}
	if (dwValidTemp == 0)
	{
		TextOut(hCompatDC,Col(45),Line(iTotalLines),Key12,lstrlen(Key12));
	}
	else
	{
		FormatMyNumber(dwValidTemp,(LPTSTR)&Line1,sizeof(Line1));
		StringCbCat((LPSTR)&Line1,sizeof(Line1),(LPCTSTR)&szDays);
		TextOut(hCompatDC,Col(45),Line(iTotalLines),Line1,lstrlen(Line1));
	}
	// Display the algorithm byte - RSA or UNK.
	// Should never have UNK on our key rings.
	//.........................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,VALIDITY_SIZE
		mov		lpKeyBufferDup1,edi
		mov		al,byte ptr [edi]

		// Get rid of any part of the time stamp in the high 7 bits.
		//..........................................................
		and		al,0x01
		mov		TempByte,al
	}
	if (TempByte == RSA_ALGORITHM)
	{
		TextOut(hCompatDC,Col(76),Line(iTotalLines),Key13,lstrlen(Key13));
	}
	else
	{
		TextOut(hCompatDC,Col(76),Line(iTotalLines),Key14,lstrlen(Key14));
	}
	iTotalLines += 2;

	// Convert the timestamp to a date and time, and the validity
	// period if we have one.
	//...........................................................
	TimestampToDateTime(liTimestampTemp.QuadPart,&stCreated);

	if (dwValidTemp)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,dwValidTemp
			mov		ecx,SECS_PER_DAY
			mul		ecx
			add		eax,liTimestampTemp.LowPart
			adc		edx,liTimestampTemp.HighPart
			mov		liValidityTimestamp.LowPart,eax
			mov		liValidityTimestamp.HighPart,edx
		}
		TimestampToDateTime(liValidityTimestamp.QuadPart,&stValidity);
	}
	// Print the date and time the key was created.
	//.............................................
	SetTextColor(hCompatDC,RGB(0,0,0));
	TextOut(hCompatDC,Col(12),Line(iTotalLines),Key15,lstrlen(Key15));
	GetDateFormat(LOCALE_USER_DEFAULT,0,&stCreated,"ddd',' dd MMM yyyy",Line1,80);
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col(36),Line(iTotalLines),Line1,lstrlen(Line1));
	StringCbPrintf(Line1,sizeof(Line1),szTime,stCreated.wHour,&TimeSep,stCreated.wMinute,
				   &TimeSep,stCreated.wSecond);
	TextOut(hCompatDC,Col(56),Line(iTotalLines),Line1,lstrlen(Line1));
	
	iTotalLines += 2;

	// If the key has a validity period print the expiration date
	// and time.
	//...........................................................
	if (dwValidTemp)
	{
		SetTextColor(hCompatDC,RGB(0,0,0));
		TextOut(hCompatDC,Col(12),Line(iTotalLines),Key16,lstrlen(Key16));
		SetTextColor(hCompatDC,RGB(0,0,255));
		StringCbPrintf(Line1,sizeof(Line1),szTime,stValidity.wHour,&TimeSep,
					   stValidity.wMinute,&TimeSep,stValidity.wSecond);
		TextOut(hCompatDC,Col(36),Line(iTotalLines),Line1,lstrlen(Line1));
		GetDateFormat(LOCALE_USER_DEFAULT,0,&stValidity,"ddd',' dd MMM yyyy",Line1,80);
		TextOut(hCompatDC,Col(52),Line(iTotalLines),Line1,lstrlen(Line1));

		iTotalLines += 2;
	}
	// Calculate and display the Md5 fingerprint.
	//...........................................
	TextOut(hCompatDC,Col(7),Line(iTotalLines),Key17,lstrlen(Key17));

	// Calculate the Md5 message digest and display fingerprint data.
	//...............................................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,dwSizeLengthField
		add		edi,(KEY_HDR1_SIZE + MPI_PREFIX_SIZE)
		mov		lpKeyBufferDup1,edi
	}
	FingerPrint(lpKeyBufferDup1,lpKeyBuffer2,TRUE);

	FillMemory(Line1,75,0x20);

	__asm
	{
		mov		esi,lpKeyBuffer1
		mov		eax,dword ptr [esi]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,Line1);

	__asm
	{
		mov		esi,lpKeyBuffer1
		mov		eax,dword ptr [esi+4]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpKeyBuffer1
		mov		eax,dword ptr [esi+8]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpKeyBuffer1
		mov		eax,dword ptr [esi+12]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	*lpReturnAddress = 0;

	SetTextColor(hCompatDC,RGB(255,0,0));
	TextOut(hCompatDC,Col(25),Line(iTotalLines),Line1,lstrlen(Line1));
	iTotalLines += 2;

	// Calculate and display the Sha message digest.
	//..............................................
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),Key64,lstrlen(Key64));

	FingerPrint(lpKeyBufferDup1,lpKeyBuffer2,FALSE);

	FillMemory(Line1,75,0x20);

	__asm
	{
		mov		esi,lpKeyBuffer2
		mov		eax,dword ptr [esi]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,Line1);

	__asm
	{
		mov		esi,lpKeyBuffer2
		mov		eax,dword ptr [esi+4]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpKeyBuffer2
		mov		eax,dword ptr [esi+8]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpKeyBuffer2
		mov		eax,dword ptr [esi+12]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	__asm
	{
		mov		esi,lpKeyBuffer2
		mov		eax,dword ptr [esi+16]
		mov		dwFingerPrintValue,eax
	}
	lpReturnAddress = DisplayHex(dwFingerPrintValue,8,lpReturnAddress);

	*lpReturnAddress = 0;

	SetTextColor(hCompatDC,RGB(255,0,0));
	TextOut(hCompatDC,Col(20),Line(iTotalLines),Line1,lstrlen(Line1));
	iTotalLines += 2;

	// Display Modulus n.
	//...................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(4),Line(iTotalLines),Key18,lstrlen(Key18));
	FormatBits(dwN_Bits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(4),Line((iTotalLines+1)),Line1,lstrlen(Line1));

	// Transfer Modulus n to the display.
	//...................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,dwSizeLengthField
		add		edi,KEY_HDR1_SIZE
		mov		lpKeyBufferDup1,edi
	}
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);
	iTotalLines ++;

	// Now transfer exponent e.
	//.........................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwScratchBits,eax
	}
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(3),Line(iTotalLines),Key7,lstrlen(Key7));
	FormatBits(dwScratchBits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(3),Line((iTotalLines+1)),Line1,lstrlen(Line1));
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);
	iTotalLines += 2;

	dwPreviousPacket = KEY_PACKET;

	// We have to go separate ways for the public and secret keys.
	//............................................................
	if (TypeKey == SECRET_KEY)
	{
		goto ProcessSecretKey;
	}
	// Process the rest of the public key. On a public key the next
	// packet should be a trust packet followed by various user ids,
	// trust packets, signature packets, and maybe a compromise
	// certificate which is a signature packet.
	//..............................................................
	while(TRUE)
	{
		// Check for end of the key.
		//..........................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			cmp		byte ptr [edi],0h
			jne		L1
			mov		bResult,TRUE
			jmp		SetupEnd
		L1: mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			mov		TempByte,al
			mov		dwCtb_Byte,ecx
		}
		// Check for trust packets.
		//.........................
		if (TempByte == CTB_TRUST)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup1,edi	// Points to trust byte.
			}
			ChangeToHex(1,lpKeyBufferDup1,Line1,FORWARD);
			SetTextColor(hCompatDC,RGB(0,0,255));
			TextOut(hCompatDC,Col(15),Line(iTotalLines),Line1,lstrlen(Line1));

			// Get the trust byte.
			//....................
			__asm
			{
				mov		edi,lpKeyBufferDup1
				mov		al,byte ptr [edi]
				mov		TrustByte,al
			}
			if (dwPreviousPacket == KEY_PACKET)
			{
				SetTextColor(hCompatDC,RGB(0,128,0));
				TextOut(hCompatDC,Col(3),Line(iTotalLines),Key19,lstrlen(Key19));

				SetTextColor(hCompatDC,RGB(255,0,0));

				// Check for the buckstop bit.
				//............................
				if (TrustByte & BUCKSTOP_BIT)
				{
					TextOut(hCompatDC,Col(71),Line(iTotalLines),Key21,lstrlen(Key21));
				}
				if (TrustByte & SELF_SIGNED_BIT)
				{
					TextOut(hCompatDC,Col(41),Line(iTotalLines),Key55,lstrlen(Key55));
				}
				if (TrustByte & DISABLED_BIT)
				{
					if (TrustByte & WHY_DISABLED)
					{
						TextOut(hCompatDC,Col(58),Line(iTotalLines),Key22,lstrlen(Key22));
					}
					else
					{
						TextOut(hCompatDC,Col(58),Line(iTotalLines),Key62,lstrlen(Key62));
					}
				}
				// Get the owner trust setting.
				//.............................
				TrustByte &= OWNER_SIG_MASK;
				if (TrustByte == NOT_INITIALIZED)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key23,lstrlen(Key23));
				}
				else if (TrustByte == NOT_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key26,lstrlen(Key26));
				}
				else if (TrustByte == MARGINAL_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key28,lstrlen(Key28));
				}
				else if (TrustByte == COMPLETE_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key29,lstrlen(Key29));
				}
				else if (TrustByte == ON_SECRET_RING)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key30,lstrlen(Key30));
				}
				else
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key63,lstrlen(Key63));
				}
			}
			else if (dwPreviousPacket == USER_ID_PACKET)
			{
				SetTextColor(hCompatDC,RGB(0,128,0));
				TextOut(hCompatDC,Col(5),Line(iTotalLines),Key57,lstrlen(Key57));
				SetTextColor(hCompatDC,RGB(255,0,0));
				if (TrustByte & WARNONLY_BIT)
				{
					TextOut(hCompatDC,Col(71),Line(iTotalLines),Key38,lstrlen(Key38));
				}
				TrustByte &= KEYLEGIT_MASK;
				if (TrustByte == NOT_INITIALIZED)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key58,lstrlen(Key58));
				}
				else if (TrustByte == UID_NOT_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key31,lstrlen(Key31));
				}
				else if (TrustByte == UID_MARG_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key32,lstrlen(Key32));
				}
				else if (TrustByte == UID_COMPL_TRUST)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key33,lstrlen(Key33));
				}
			}
			else if (dwPreviousPacket == SIG_PACKET)
			{
				SetTextColor(hCompatDC,RGB(0,128,0));
				TextOut(hCompatDC,Col(5),Line(iTotalLines),Key56,lstrlen(Key56));
				SetTextColor(hCompatDC,RGB(255,0,0));
				if (TrustByte & SELF_SIGNED_BIT)
				{
					TextOut(hCompatDC,Col(49),Line(iTotalLines),Key54,lstrlen(Key54));
				}
				if (TrustByte & CHECKED_BIT)
				{
					TextOut(hCompatDC,Col(63),Line(iTotalLines),Key39,lstrlen(Key39));
				}
				if (TrustByte & CONTIG_BIT)
				{
					TextOut(hCompatDC,Col(73),Line(iTotalLines),Key40,lstrlen(Key40));
				}
				if (TrustByte & SELF_SIGNED_BIT)
				{
					TextOut(hCompatDC,Col(18),Line(iTotalLines),Key60,lstrlen(Key60));
				}
				else
				{
					TrustByte &= OWNER_SIG_MASK;
					if (TrustByte == NOT_INITIALIZED)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key23,lstrlen(Key23));
					}
					else if (TrustByte == UNKNOWN_OWNER)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key59,lstrlen(Key59));
					}
					else if (TrustByte == NOT_TRUST)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key34,lstrlen(Key34));
					}
					else if (TrustByte == MARGINAL_TRUST)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key35,lstrlen(Key35));
					}
					else if (TrustByte == COMPLETE_TRUST)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key36,lstrlen(Key36));
					}
					else if (TrustByte == ON_SECRET_RING)
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key37,lstrlen(Key37));
					}
					else
					{
						TextOut(hCompatDC,Col(18),Line(iTotalLines),Key63,lstrlen(Key63));
					}
				}
			}
			// Get past the trust byte.
			//.........................
			lpKeyBufferDup1++;
			iTotalLines += 2;
			if (CheckLines())
			{
				goto SetupEnd;
			}
		}
		else if (TempByte == CTB_USER_ID)
		{
			SetTextColor(hCompatDC,RGB(0,0,0));
			TextOut(hCompatDC,Col(6),Line(iTotalLines),Key20,lstrlen(Key20));
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		dwUserIDLength,eax
				mov		lpUserID,edi
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
			SetTextColor(hCompatDC,RGB(0,0,255));
			while(dwUserIDLength != 0)
			{
				if (dwUserIDLength > 64)
				{
					dwBytesToPrint = 64;
					dwUserIDLength -= 64;
				}
				else
				{
					dwBytesToPrint = dwUserIDLength;
					dwUserIDLength = 0;
				}
				TextOut(hCompatDC,Col(15),Line(iTotalLines),lpUserID,dwBytesToPrint);
				iTotalLines++;
				lpUserID += dwBytesToPrint;
			}
			dwPreviousPacket = USER_ID_PACKET;
			iTotalLines++;
		}
		else if (TempByte == CTB_SKE_PACKET)
		{
			// Signature packet. Could be a compromise certificate
			// of a key signature.
			//....................................................
			SetTextColor(hCompatDC,RGB(0,128,0));
			TextOut(hCompatDC,Col(1),Line(iTotalLines),Key44,lstrlen(Key44));
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpSigEndAddress,edi
				add		lpSigEndAddress,eax

				// Point to classification field. Put it in TempByte.
				//...................................................
				add		edi,2
				mov		lpKeyBufferDup1,edi
				mov		al,byte ptr [edi]
				mov		TempByte,al
			}
			SetTextColor(hCompatDC,RGB(0,0,255));
			if (TempByte >= KEY_CERT_GEN && TempByte <= KEY_CERT_SELF)
			{
				TextOut(hCompatDC,Col(24),Line(iTotalLines),Key45,lstrlen(Key45));
			}
			else if (TempByte == KEY_COMPROMISE)
			{
				SetTextColor(hCompatDC,RGB(255,0,0));
				TextOut(hCompatDC,Col(24),Line(iTotalLines),Key50,lstrlen(Key50));
			}
			else
			{
				TextOut(hCompatDC,Col(24),Line(iTotalLines),Key63,lstrlen(Key63));
			}
			SetTextColor(hCompatDC,RGB(255,0,0));
			if (TempByte == KEY_CERT_GEN)
			{
				TextOut(hCompatDC,Col(44),Line(iTotalLines),Key46,lstrlen(Key46));
			}
			else if (TempByte == KEY_CERT_PER)
			{
				TextOut(hCompatDC,Col(44),Line(iTotalLines),Key47,lstrlen(Key47));
			}
			else if (TempByte == KEY_CERT_CAS)
			{
				TextOut(hCompatDC,Col(44),Line(iTotalLines),Key48,lstrlen(Key48));
			}
			else if (TempByte == KEY_CERT_POS)
			{
				TextOut(hCompatDC,Col(44),Line(iTotalLines),Key49,lstrlen(Key49));
			}
			else if (TempByte == KEY_CERT_SELF)
			{
				TextOut(hCompatDC,Col(44),Line(iTotalLines),Key54,lstrlen(Key54));
			}
			// Get the signature algorithm and display it.
			//............................................
			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,14
				mov		al,byte ptr [edi]
				mov		TempByte,al
			}
			SetTextColor(hCompatDC,RGB(0,0,255));
			if (TempByte == MD5_ALGORITHM)
			{
				TextOut(hCompatDC,Col(56),Line(iTotalLines),Key66,lstrlen(Key66));
			}
			else if (TempByte == SHA_ALGORITHM)
			{
				TextOut(hCompatDC,Col(56),Line(iTotalLines),Key67,lstrlen(Key67));
			}
			else if (TempByte == SHA512_ALGORITHM)
			{
				TextOut(hCompatDC,Col(56),Line(iTotalLines),Key68,lstrlen(Key68));
			}
			// Process the timestamp next even though it is not
			// displayed yet.
			//.................................................
			liSigTimeStamp.QuadPart = 0;
			__asm
			{
				mov		edi,lpKeyBufferDup1
				inc		edi
				mov		eax,dword ptr [edi]
				bswap	eax
				mov		liSigTimeStamp.LowPart,eax
				mov		lpKeyBufferDup1,edi

				// Get the high order 7 bits of the timestamp.
				//............................................
				mov		eax,dword ptr [edi+12]
				and		eax,0x00ff
				shr		eax,1
				mov		liSigTimeStamp.HighPart,eax
			}
			TimestampToDateTime(liSigTimeStamp.QuadPart,&stSigTime);

			// Process the key id. Save full 8 byte key id for search.
			//........................................................
			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,TIMESTAMP_SIZE
				push	edi
				mov		esi,edi
				mov		edi,offset KeySID
				mov		ecx,8
				rep		movsb
				pop		edi
				add		edi,SHORT_KEY_ID
				mov		lpKeyBufferDup1,edi
			}
			SetTextColor(hCompatDC,RGB(0,128,0));
			TextOut(hCompatDC,Col(63),Line(iTotalLines),Key51,lstrlen(Key51));
			SetTextColor(hCompatDC,RGB(0,0,255));
			ChangeToHex(SHORT_KEY_ID,lpKeyBufferDup1,Line1,FORWARD);
			TextOut(hCompatDC,Col(71),Line(iTotalLines),Line1,lstrlen(Line1));

			// Now transfer the date and time the signature was made.
			//.......................................................
			iTotalLines += 2;
			if (CheckLines())
			{
				goto SetupEnd;
			}
			SetTextColor(hCompatDC,RGB(0,0,0));
			TextOut(hCompatDC,Col(12),Line(iTotalLines),Key61,lstrlen(Key61));

			GetDateFormat(LOCALE_USER_DEFAULT,0,&stSigTime,"ddd',' dd MMM yyyy",Line1,80);
			SetTextColor(hCompatDC,RGB(0,0,255));
			TextOut(hCompatDC,Col(36),Line(iTotalLines),Line1,lstrlen(Line1));

			StringCbPrintf(Line1,sizeof(Line1),szTime,stSigTime.wHour,&TimeSep,
						   stSigTime.wMinute,&TimeSep,stSigTime.wSecond);
			TextOut(hCompatDC,Col(56),Line(iTotalLines),Line1,lstrlen(Line1));
	
			iTotalLines += 2;
			if (CheckLines())
			{
				goto SetupEnd;
			}
			// Now get the 8 byte key id and search for its public
			// key in the public key ring so we can display the sig
			// id.
			//.....................................................
			li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
											 0,&KeyIdSearch);
			if (li.QuadPart == -1)
			{
				goto SetupEnd;
			}
			// If we did not have a match, say so.
			//....................................
			if (li.QuadPart == 0)
			{
				SetTextColor(hCompatDC,RGB(0,128,0));
				TextOut(hCompatDC,Col(7),Line(iTotalLines),Key52,lstrlen(Key52));
				SetTextColor(hCompatDC,RGB(0,0,255));
				TextOut(hCompatDC,Col(15),Line(iTotalLines),Key53,lstrlen(Key53));
				iTotalLines += 2;
				if (CheckLines())
				{
					goto SetupEnd;
				}
			}
			// We had a match. Get the signer's public key in
			// lpKeyBuffer2 so we can display the sig ids for
			// the signature certificate.
			//................................................
			else
			{
				// Read the index file record that has the file
				// offset of the signer's public key.

				dwIdxOffset2 = li.HighPart;
				dwBytesRead = ReadIndex2();
				if (dwBytesRead == -1 || dwBytesRead == 0)
				{
					goto SetupEnd;
				}

				dwBytesRead = ReadRecord2();
				if (dwBytesRead == -1 || dwBytesRead == 0)
				{
					goto SetupEnd;
				}
				// Search the signer's public key for the ids.
				//............................................
				lpKeyBufferDup2 = lpKeyBuffer2;
				while(TRUE)
				{
					__asm
					{
						mov		edi,lpKeyBufferDup2
						mov		al,byte ptr [edi]
						mov		TempByte,al
						mov		cl,al
						mov		dwCtb_Byte,ecx
					}
					if (TempByte == 0)
					{
						break;
					}
					TempByte &= CTB_MASK;
					GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup2
						add		edi,CTB_SIZE
						add		edi,edx
						mov		lpUserID,edi
						mov		dwUserIDLength,eax
						add		edi,eax
						mov		lpKeyBufferDup2,edi
					}
					// If this packet is not a user ID go to the
					// next packet.
					//..........................................
					if (TempByte != CTB_USER_ID)
					{
						continue;
					}
					// We have a signature id, display it.
					//....................................
					SetTextColor(hCompatDC,RGB(0,128,0));
					TextOut(hCompatDC,Col(7),Line(iTotalLines),Key52,lstrlen(Key52));
					SetTextColor(hCompatDC,RGB(0,0,255));
					while(dwUserIDLength != 0)
					{
						if (dwUserIDLength > 64)
						{
							dwBytesToPrint = 64;
							dwUserIDLength -= 64;
						}
						else
						{
							dwBytesToPrint = dwUserIDLength;
							dwUserIDLength = 0;
						}
						TextOut(hCompatDC,Col(15),Line(iTotalLines),lpUserID,dwBytesToPrint);
						iTotalLines++;
						if (CheckLines())
						{
							goto SetupEnd;
						}
						lpUserID += dwBytesToPrint;
					}	// while(dwUserIDLenght != 0
					iTotalLines++;
					if (CheckLines())
					{
						goto SetupEnd;
					}
				}	// while(TRUE)
			}	// endif
			lpKeyBufferDup1 = lpSigEndAddress;
			dwPreviousPacket = SIG_PACKET;
		}
		else
		{
			// Not a valid packet type for a public key ring.
			// Bail out. Should never happen on our key rings.
			//................................................
			SetLastError(IDS_CORRUPTPUBLICKEYRING);
			ErrorProcedure((LPTSTR)&cfg.szPublicKeyRing,IDS_VIEWRINGS,MB_OK);
			goto SetupEnd;
		}
	}	// while(TRUE)

	// Process the rest of the secret key.
	//....................................
	ProcessSecretKey:
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),Key24,lstrlen(Key24));

	// Get past the cipher algorithm byte.
	//....................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		inc		edi
		mov		lpKeyBufferDup1,edi
		mov		al,byte ptr [edi-1]
		mov		TempByte,al
	}
	// If the cipher algorithm byte does not equal 0 the secret
	// components are encrypted. Check to see if we can decipher
	// them. Should never be the case on our key rings.
	//..........................................................
	if (TempByte != NO_ENCRYPTION)
	{
		if (TempByte != TSC_ALGORITHM)
		{
			SetTextColor(hCompatDC,RGB(0,0,0));
			TextOut(hCompatDC,Col(24),Line(iTotalLines),Key41,lstrlen(Key41));
			iTotalLines += 2;
			
			// Can't display secret components. Setup to display
			// user ids.
			//..................................................
			__asm
			{
				mov		edi,lpKeyBuffer1
				add		edi,dwKeyLength
				mov		lpKeyBufferDup1,edi
			}
			goto DisplayUserIds;
		}
		else
		{
			// Only decipher the secret components if authorized to.
			//......................................................
			if (!bAa || (bAa && (cfg.V1.dwV3 & PERMIT_VIEW_SEC_COMPON || 
				!bRestrictionsInEffect)))
			{
				// Decipher the secret components.
				//................................
				lpKeyBufferDup1 += CFB_LENGTH;
				lpEncAddress = lpKeyBufferDup1;

				// Length of enciphered secret components equals
				// total length of the secret key minus the offset
				// of the first byte of the secret components. This
				// includes mpi prefixes and checksum.
				//.................................................
				__asm
				{
					mov		eax,lpKeyBuffer1
					add		eax,dwKeyLength
					sub		eax,lpEncAddress
					mov		dwBytesToEncipher,eax
				}
				// Get the current pass phrase to decipher the secret
				// components with.
				//...................................................
				CopyMemory(lpKeyBuffer2,lpKeyBuffer1,SIZE_KEY_BUFF);
				ZeroMemory(&TempUserId,256);
				CopyMemory(&TempUserId,&UserIdIndex1.USER_ID,255);
				uiGetPassPhraseMsg = IDS_NODISPLAYSC;

				while(TRUE)
				{
					iDlgResult = DialogBox(hInst,TEXT("GETCURRENTPASSPHRASE"),
									       hMainWindow,(DLGPROC)GetCurrentPassPhraseProc);

					// See if we had a system error in creating the 
					// dialog box.
					//.............................................
					if (iDlgResult == -1)
					{
						ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
						goto SetupEnd;
					}
					// If we did not enter a pass phrase, or we do not know
					// the pass phrase, go and display the user ids.
					//.....................................................
					if (iDlgResult == IDCANCEL)
					{
						SetTextColor(hCompatDC,RGB(255,0,0));
						TextOut(hCompatDC,Col(24),Line(iTotalLines),Key42,lstrlen(Key42));
						iTotalLines += 2;
						__asm
						{
							mov		edi,lpKeyBuffer1
							add		edi,dwKeyLength
							mov		lpKeyBufferDup1,edi
						}
						goto DisplayUserIds;
					}

					EmptyTheMessageQue();

					// We entered a pass phrase, see if it is the right one.
					//......................................................
					DecipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncAddress,
											  iLengthOfPassPhrase,dwBytesToEncipher);

					EmptyTheMessageQue();

					// Do the checksum on the secret components.
					//..........................................
					dwCheckSum = CheckSum(lpEncAddress,(dwBytesToEncipher-2));

					__asm
					{
						mov		edi,lpEncAddress
						mov		ebx,dwBytesToEncipher
						sub		ebx,2
						movzx	eax,word ptr [edi][ebx]
						xchg	ah,al
						mov		edx,dwCheckSum
						cmp		eax,edx
						je		DisplaySecretComponents
					}
					// An invalid pass phrase was entered. Say so.
					//............................................
					CopyMemory(lpKeyBuffer1,lpKeyBuffer2,SIZE_KEY_BUFF);
					MessageBoxProc(hWnd,IDS_INPUT_ERROR,IDS_INVALIDCHECKPP,
								   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				}	// while(TRUE)
			}
			else
			{
				// Not authorized to display secret components.
				//.............................................
				SetTextColor(hCompatDC,RGB(255,0,0));
				TextOut(hCompatDC,Col(24),Line(iTotalLines),Key65,lstrlen(Key65));
				iTotalLines += 2;
				__asm
				{
					mov		edi,lpKeyBuffer1
					add		edi,dwKeyLength
					mov		lpKeyBufferDup1,edi
				}
				goto DisplayUserIds;
			}
		}
	}
	else
	{
		// Secret key components not encrypted.
		//.....................................
		SetTextColor(hCompatDC,RGB(255,0,0));
		TextOut(hCompatDC,Col(24),Line(iTotalLines),Key43,lstrlen(Key43));
	}
  DisplaySecretComponents:

	// Clear any pass phrase entered.
	//...............................
	ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));

	// The secret componets of the secret key are not enciphered,
	// or have been deciphered. Transfer them to the display buffer.
	//..............................................................
	iTotalLines += 2;
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Display exponent d.
	//....................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwScratchBits,eax
	}
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(3),Line(iTotalLines),Key8,lstrlen(Key8));
	FormatBits(dwScratchBits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(3),Line((iTotalLines+1)),Line1,lstrlen(Line1));
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);

	iTotalLines++;
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Display prime p.
	//.................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwScratchBits,eax
	}
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(6),Line(iTotalLines),Key9,lstrlen(Key9));
	FormatBits(dwScratchBits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(6),Line((iTotalLines+1)),Line1,lstrlen(Line1));
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);

	iTotalLines++;
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Display prime q.
	//.................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwScratchBits,eax
	}
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(6),Line(iTotalLines),Key10,lstrlen(Key10));
	FormatBits(dwScratchBits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(6),Line((iTotalLines+1)),Line1,lstrlen(Line1));
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);

	iTotalLines++;		
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Display inverse u.
	//...................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwScratchBits,eax
	}
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(4),Line(iTotalLines),Key11,lstrlen(Key11));
	FormatBits(dwScratchBits);
	SetTextColor(hCompatDC,RGB(90,90,90));
	TextOut(hCompatDC,Col(4),Line((iTotalLines+1)),Line1,lstrlen(Line1));
	lpKeyBufferDup1 = TransferMPI(lpKeyBufferDup1,FORWARD,1);

	iTotalLines++;
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Transfer the 16 bit checksum.
	//..............................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(5),Line(iTotalLines),Key27,lstrlen(Key27));
	ChangeToHex(2,lpKeyBufferDup1,Line1,FORWARD);
	SetTextColor(hCompatDC,RGB(0,0,255));
	TextOut(hCompatDC,Col(15),Line(iTotalLines),Line1,lstrlen(Line1));

	lpKeyBufferDup1 += CHECKSUM_SIZE;	// Point to user id ctb.

	iTotalLines += 2;
	if (CheckLines())
	{
		goto SetupEnd;
	}
	// Transfer the user ids. May be more than one.
	//.............................................
	DisplayUserIds:
	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			cmp		byte ptr [edi],0
			jne		L2
			mov		bResult,TRUE
			jmp		SetupEnd
		L2:	mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			mov		TempByte,al
			mov		dwCtb_Byte,ecx
		}
		if (TempByte == CTB_USER_ID)
		{
			SetTextColor(hCompatDC,RGB(0,0,0));
			TextOut(hCompatDC,Col(6),Line(iTotalLines),Key20,lstrlen(Key20));
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		dwUserIDLength,eax
				mov		lpUserID,edi
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
			SetTextColor(hCompatDC,RGB(0,0,255));
			while(dwUserIDLength != 0)
			{
				if (dwUserIDLength > 64)
				{
					dwBytesToPrint = 64;
					dwUserIDLength -= 64;
				}
				else
				{
					dwBytesToPrint = dwUserIDLength;
					dwUserIDLength = 0;
				}
				TextOut(hCompatDC,Col(15),Line(iTotalLines),lpUserID,dwBytesToPrint);
				iTotalLines++;
				lpUserID += dwBytesToPrint;
			}
			iTotalLines++;
		}
		else
		{
			// Not a valid packet type for a secret key ring.
			// Bail out. Should never happen on our key rings.
			//................................................
			SetLastError(IDS_CORRUPTSECRETKEYRING);
			ErrorProcedure((LPTSTR)&cfg.szSecretKeyRing,IDS_VIEWRINGS,MB_OK);
			goto SetupEnd;
		}
	}	// while(TRUE)

	bResult = TRUE;
	SetupEnd:
	// Last total lines value should be 2 more that actual total lines.
	//.................................................................
	iTotalLines += 2;

	// Set the new scroll information for this key.
	//.............................................
	yMax = max(0,iTotalLines + 2 - (yClient/yChar));
	xPos = 0;
	yPos = 0;
	sci.cbSize = sizeof(SCROLLINFO);
	sci.fMask = SIF_POS;
	sci.nPos = xPos;
	EnableScrollBar(hWnd,SB_HORZ,ESB_ENABLE_BOTH);
	SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);

	// Set the position and range of the new
	// key for the y axis.
	//......................................
	sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
	sci.nMax = iTotalLines -1;
	sci.nMin = 0;
	sci.nPage = yClient/yChar + 1;
	sci.nPos = yPos;
	EnableScrollBar(hWnd,SB_VERT,ESB_ENABLE_BOTH);
	SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);

	// Make the old selection the same as our current selection.
	//..........................................................
	iOldSelection = iNewSelection;
	bScrollWnd = FALSE;
	return(bResult);
}

// Trap the tab key using the keyboard hook procedure so we can
// switch between windows.
//..............................................................
LRESULT CALLBACK TrapViewTabKey(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HC_ACTION)
	{
		if (wParam == VK_TAB)
		{
			if (dwChangeFocus == 0)
			{
				if (hCurrentFocusWin == hViewComboBox)
				{
					hCurrentFocusWin = hViewWindow;
				}
				else
				{
					hCurrentFocusWin = hViewComboBox;
				}
				SetFocus(hCurrentFocusWin);
				dwChangeFocus = 1;
			}
			else
			{
				dwChangeFocus--;
			}
			return(TRUE);
		}
		else 
		{
			return(0);
		}
	}
	else
	{
		return(CallNextHookEx(hHook,nCode,wParam,lParam));
	}
}

// Change the input to hex values.
//................................
VOID ChangeToHex(DWORD dwCount, LPBYTE lpSource, LPBYTE lpDestination, DWORD dwDirection)
{
	__asm
	{
		// Fill the buffer with zeros.
		//............................
		mov		edi,lpDestination
		mov		ecx,dwCount
		shl		ecx,1
		inc		ecx
		mov		al,0h
		rep		stosb
	}
	if (dwCount > 0)
	{
		__asm
		{
			mov		ecx,dwCount
			mov		edi,lpDestination
			mov		esi,lpSource
		L1: xor		eax,eax
			cmp		dwDirection,BACKWARD
			jne		L2
			std
		L2:	lodsb
			cld
			BHEX
			add		ax,'00'
			cmp		al,'9'
			jbe		L3
			add		al,7h
		L3: cmp		ah,'9'
			jbe		L4
			add		ah,7h
		L4: xchg	ah,al
			stosb
			xchg	ah,al
			stosb
			dec		ecx
			jnz		L1
		}
	}
}

// Calculate the fingerprint for a key which is composed of Modulus n
// and exponent e.
//...................................................................
VOID FingerPrint(LPBYTE lpModulusN, LPBYTE lpWorkBuffer, BOOL bMd5)
{
	DWORD	dwBufferLength;

	// First get the total length of modulus n and exponent e
	// and transfer them to a work buffer.
	//.......................................................
	__asm
	{
		mov		esi,lpModulusN
		movzx	ecx,word ptr [esi-2]
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwBufferLength,ecx
		push	ecx
		push	esi
		mov		edi,lpWorkBuffer
		rep		movsb
		pop		esi
		pop		ecx
		add		esi,ecx
		add		esi,2		// Past e MPI bit count.
		movzx	ecx,word ptr [esi-2]
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		add		dwBufferLength,ecx
		rep		movsb
	}
	// Perform the MD5 calculations on modulus n and exponent e
	// to get the fingerprint.
	//.........................................................
	if (bMd5)
	{
		Md5Initialize(&Md5Context);
		Md5Update(&Md5Context,lpWorkBuffer,dwBufferLength);
		Md5Final(lpWorkBuffer,&Md5Context);
	}
	else
	{
		ShaInit(&ShaContext);
		ShaUpdate(&ShaContext,lpWorkBuffer,dwBufferLength);
		ShaFinal(lpWorkBuffer,&ShaContext);
	}
	// Byte swap the values and put them back into the buffer.
	//........................................................
	__asm
	{
		mov		edi,lpWorkBuffer
		mov		eax,dword ptr [edi]
		mov		ebx,dword ptr [edi+4]
		mov		ecx,dword ptr [edi+8]
		mov		edx,dword ptr [edi+12]
		bswap	eax
		bswap	ebx
		bswap	ecx
		bswap	edx
		mov		dword ptr [edi],eax
		mov		dword ptr [edi+4],ebx
		mov		dword ptr [edi+8],ecx
		mov		dword ptr [edi+12],edx

		// Just in case we are doing the Sha digest.
		//..........................................
		mov		eax,dword ptr [edi+16]
		bswap	eax
		mov		dword ptr [edi+16],eax
	}
}

// Convert a byte, word, or dword to hexadecimal ascii characters
// and place them in the designated buffer. Returns the last address
// in the destination.
//..................................................................
LPBYTE DisplayHex(DWORD dwValue, DWORD dwCharacters,LPBYTE lpDestination)
{
	LPBYTE		lpLastEDI;

	__asm
	{
		mov		ebx,dwValue
		mov		ecx,dwCharacters
		mov		edi,lpDestination

		// Left justify the value in ebx.
		//...............................
		cmp		ecx,2
		jne		L1
		shl		ebx,24
		jmp		L2
	L1:	cmp		ecx,4
		jne		L2
		shl		ebx,16
	L2:	shr		cx,1
	L3:	push	ecx
		mov		ecx,2
	L4:	rol		ebx,4
		mov		al,bl
		and		al,0fh
		cmp		al,9
		ja		L5
		add		al,30h
		jmp		L6
	L5:	add		al,37h
	L6:	stosb
		dec		ecx
		jnz		L4
		pop		ecx
		inc		edi
		dec		ecx
		jnz		L3
		mov		lpLastEDI,edi
	}
	return(lpLastEDI);
}

// Format the number of bits in a MPI for display.
//................................................
VOID FormatBits(DWORD dwBits)
{
	FormatMyNumber(dwBits,szBits,24);
	StringCbCopy(Line1,sizeof(Line1),szLeftP);
	StringCbCat(Line1,sizeof(Line1),szBits);
	StringCbCat(Line1,sizeof(Line1),szRightP);
}

// Transfer a MPI, a multiprecision number, in hex.
//.................................................
// Entry: lpKeyBufferDup1 points to the MPI. First
//        two bytes contains the bit count. 
//        iTotalLines points to the first line to
//        transfer the MPI to. Default source
//        direction = FORWARD and skip lines = 1.
//
// Exit:  lpKeyBufferDup1 points to the next MPI
//        or CTB. iTotalLine points to next line
//        after last line of MPI.
//.................................................
LPBYTE TransferMPI(LPBYTE lpSource, DWORD dwSourceDirection, DWORD dwSkipLines)
{
	DWORD		dwChangeCount;
	BOOL		bLastByte2;
	LPBYTE		lpSourceMPI;
	LPBYTE		lpDestination;

	// Fill line one with spaces in case the first line does not
	// fill it up.
	//..........................................................
	FillMemory(Line1,64,0x20);
	Line1[64] = 0;

	// Set the text color for the mpi.
	//................................
	SetTextColor(hCompatDC,RGB(0,0,0));

	// Get the bit count of the number and convert it to a byte count.
	//................................................................
	__asm
	{
		mov		edi,lpSource
		movzx	eax,word ptr [edi]
		add		edi,2			// Point to first byte of mpi.
		xchg	ah,al
		xor		edx,edx
		mov		ecx,8
		div		ecx
		cmp		edx,0
		je		L1
		inc		eax
	L1:	mov		ecx,eax

		// Does the last byte of the MPI have two or one hex digit?
		//.........................................................
		mov		bLastByte2,FALSE
		cmp		edx,0
		je		L2
		cmp		edx,5
		jb		L3
	L2:	mov		bLastByte2,TRUE

		// If we are going in reverse we have to set edi to the
		// first byte at the end. Add the number of bytes minus
		// 1 to edi.
		//.....................................................
	L3:	cmp		dwSourceDirection,BACKWARD
		jne		L4
		add		edi,ecx
		dec		edi

		// Save the start address in the mpi.
		//...................................
	L4: mov		lpSourceMPI,edi

		// Save the number of bytes in ecx. Calculate the number of
		// bytes to display on the first line. Max of 32.
		//.........................................................
		mov		eax,ecx
		xor		edx,edx
		mov		ebx,32
		div		ebx
		mov		dwChangeCount,edx
		cmp		edx,0
		jne		L5
		mov		dwChangeCount,32

		// Calculate the number of 64 byte lines it will take to
		// display the mpi.
		//......................................................
	L5: mov		eax,ecx
		shl		eax,1
		xor		edx,edx
		mov		ecx,64
		div		ecx
		cmp		edx,0
		je		L6
		inc		eax
	L6: mov		ecx,eax
	L7:	push	ecx
		mov		ebx,32
		sub		ebx,dwChangeCount
		shl		ebx,1
		push	ebx
		mov		eax,offset Line1
		add		eax,ebx
		mov		lpDestination,eax
	}
	ChangeToHex(dwChangeCount,lpSourceMPI,lpDestination,dwSourceDirection);

	// If there were not two bytes in the first hex value
	// make the first one a space.
	//...................................................
	__asm
	{
		pop		ebx
		cmp		bLastByte2,TRUE
		je		L8
		mov		al,20h
		mov		edi,offset Line1
		add		edi,ebx
		stosb
		mov		bLastByte2,TRUE
	L8:
	}
	TextOut(hCompatDC,Col(15),Line(iTotalLines),Line1,lstrlen(Line1));
	iTotalLines += dwSkipLines;

	// Setup to get the next line of the mpi.
	//.......................................
	if (dwSourceDirection == FORWARD)
	{
		lpSourceMPI += dwChangeCount;
	}
	else
	{
		lpSourceMPI -= dwChangeCount;
	}
	dwChangeCount = 32;

	__asm
	{
		pop		ecx
		dec		ecx
		jnz		L7
	}
	return(lpSourceMPI);
}

// Check and make sure we do not have to many lines.
//..................................................
BOOL CheckLines()
{
	BOOL	bTooManyLines = FALSE;

	if (iTotalLines > MAX_LINES)
	{
		bTooManyLines = TRUE;

		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_TOOMANYLINES,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	return(bTooManyLines);
}
